 ; Ŀ
 ;   Tmx - line neatener for terminal blocks.                              
 ;   Copyright 2002, 2003, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Tm - the mechanism.                                        
 ;   Pans the block insertion point to the centre of the screen, decides   
 ;   whether it is a triangular block or not, looks where the wires        
 ;   should be and if they are found and they are not the same entity      
 ;   (i.e. there is a break where the block is) repositions their ends.    
 ;                                                                         
 ;   Arguments: Enam, the block entity name.                               
 ;   Calls Panora to pan to the correct location.                          
 ;   Returns nothing.                                                      
 ; 
 (DEFUN TM (enam / entt pa blnam par pal enamel enamer ss)
  (setq entt (entget enam))
 ; Ŀ
 ;   Get the entity insertion point, pan to it.                            
 ; 
  (setq pa (cdr (assoc 10 entt)))
  (panora pa)
 ; Ŀ
 ;   Get the search and proper end distances based on the block name.      
 ; 
  (setq blnam (cdr (assoc 2 entt)))
  (cond ((= (strcase (substr blnam 5 2) t) "tr")
         (setq fdist 2.5)               ; search distance from insertion
         (setq mdist 1.25))             ; desired distance from insertion
        ((member (strcase blnam t) '("fuse" "fieldterminal"))
         (setq fdist 7.5)
         (setq mdist 5))
        ((member (strcase blnam t) '("push-nc" "push-no"
                                     "contact-nc" "contact-no"
                                     "lsh"))
         (setq fdist 7.5)
         (setq mdist 5))
        ((member (strcase blnam t) '("schemarelay"))
         (setq fdist 15)
         (setq mdist 12.5))
        (t
         (setq fdist 3.5)
         (setq mdist 2.5)))
 ; Ŀ
 ;   Calculate the search positions.                                       
 ; 
  (setq par (polar pa 0 fdist))
  (setq pal (polar pa pi fdist))
 ; Ŀ
 ;   Look there.                                                           
 ; 
  (if (setq ss (ssget pal))
      (setq enamel (ssname ss 0)))
  (if (setq ss (ssget par))
      (setq enamer (ssname ss 0)))
 ; Ŀ
 ;   Reposition the entities found there.  And hope that they were lines.  
 ; 
  (if (not (equal enamel enamer))
      (progn
           (if enamel (command "change" enamel "" (polar pa pi mdist)))
           (if enamer (command "change" enamer "" (polar pa 0 mdist)))))
 (princ))
 ; Ŀ
 ;   Subroutine Tm end.                                                    
 ; 

 ; Ŀ
 ;   Subroutine Panora - pan a point to the centre of the screen.          
 ;   Arguments: Pa, the point to move to the screen centre.                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN PANORA (pa / ctr)
  (setq ctr (getvar "viewctr"))
  (command ".-pan" pa ctr)
 (princ))
 ; Ŀ
 ;   Subroutine Panora end.                                                
 ; 

 ; Ŀ
 ;   Subroutine Deck - find the size of the current view.                  
 ;   Brooks no Arguments.                                                  
 ;   Returns a list: lower left, upper right, and view height.             
 ; 
 (DEFUN DECK ( / a vs vs2 ctr w maxx minx maxy miny ll ur)
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (getvar "viewsize"))            ; view height in drawing units
  (setq vs2 (* vs 0.5))                    ; view half height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs2 a ))                      ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs2))
  (setq miny (- (cadr ctr) vs2))
  (setq ll (list minx miny))
  (setq ur (list maxx maxy))
 (list ll ur vs))
 ; Ŀ
 ;   Subroutine Deck end.                                                  
 ; 

 ; Ŀ
 ;   Tmx.                                                                  
 ; 
 (DEFUN C:TMX (/ ss window curht zoomf num enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get entities to neaten wiring to.                                     
 ; 
  (prompt "Select terminals or <Return> for all: ")
  (if (null (setq ss (ssget (list (cons 2
              "term*,fieldterminal,fuse,contact-*,push-*,lsh,schemarelay")))))
      (setq ss (ssget "X" (list (cons 2
              "term*,fieldterminal,fuse,contact-*,push-*,lsh,schemarelay")))))
  (if ss
      (progn
 ; Ŀ
 ;   Save the current view, zoom to a reasonable magnification.            
 ; 
           (setq window (deck))
           (setq curht (caddr window))
           (setq desz (* 50 (misps)))
           (setq zoomf (/ curht desz))
           (command ".zoom" (strcat (rtos zoomf 2) "x"))
 ; Ŀ
 ;   Pan to each entity and realign any lines going to it.                 
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (tm enam))
 ; Ŀ
 ;   Zoom to the original view.                                            
 ; 
           (command ".zoom" (car window) (cadr window))))
  (command "undo" "end")
 (princ))